/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

import java.util.Arrays;
import jpcsp.media.codec.atrac3plus.Atrac3plusDecoder;
import jpcsp.media.codec.util.IBitReader;
import org.apache.log4j.Logger;

public class VLC {
    private static Logger log = Atrac3plusDecoder.log;
    public int bits;
    public int[][] table;
    public int tableSize;
    public int tableAllocated;

    public int initVLCSparse(int[] bits, int[] codes, int[] symbols) {
        return this.initVLCSparse(bits.length, codes.length, bits, codes, symbols);
    }

    public int initVLCSparse(int nbBits, int nbCodes, int[] bits, int[] codes, int[] symbols) {
        int i;
        Object[] buf = new VLCcode[nbCodes + 1];
        this.bits = nbBits;
        int j = 0;
        for (i = 0; i < nbCodes; ++i) {
            buf[j] = new VLCcode();
            ((VLCcode)buf[j]).bits = bits[i];
            if (((VLCcode)buf[j]).bits <= nbBits) continue;
            if (((VLCcode)buf[j]).bits > 3 * nbBits || ((VLCcode)buf[j]).bits > 32) {
                log.error((Object)String.format("Too long VLC (%d) in initVLC", ((VLCcode)buf[j]).bits));
                return -1;
            }
            ((VLCcode)buf[j]).code = codes[i];
            if (((VLCcode)buf[j]).code >= 1 << ((VLCcode)buf[j]).bits) {
                log.error((Object)String.format("Invalid code in initVLC", new Object[0]));
                return -1;
            }
            ((VLCcode)buf[j]).code <<= 32 - ((VLCcode)buf[j]).bits;
            ((VLCcode)buf[j]).symbol = symbols != null ? symbols[i] : i;
            ++j;
        }
        Arrays.sort(buf, 0, j);
        for (i = 0; i < nbCodes; ++i) {
            buf[j] = new VLCcode();
            ((VLCcode)buf[j]).bits = bits[i];
            if (((VLCcode)buf[j]).bits == 0 || ((VLCcode)buf[j]).bits > nbBits) continue;
            ((VLCcode)buf[j]).code = codes[i];
            ((VLCcode)buf[j]).code <<= 32 - ((VLCcode)buf[j]).bits;
            ((VLCcode)buf[j]).symbol = symbols != null ? symbols[i] : i;
            ++j;
        }
        nbCodes = j;
        return this.buildTable(nbBits, nbCodes, (VLCcode[])buf, 0);
    }

    private int buildTable(int tableNbBits, int nbCodes, VLCcode[] codes, int codeOffset) {
        int i;
        int tableSize = 1 << tableNbBits;
        if (tableNbBits > 30) {
            return -1;
        }
        int tableIndex = this.allocTable(tableSize);
        if (tableIndex < 0) {
            return tableIndex;
        }
        for (i = 0; i < nbCodes; ++i) {
            int k;
            int n = codes[codeOffset + i].bits;
            int code = codes[codeOffset + i].code;
            int symbol = codes[codeOffset + i].symbol;
            if (n <= tableNbBits) {
                int j = code >>> 32 - tableNbBits;
                int nb = 1 << tableNbBits - n;
                int inc = 1;
                for (int k2 = 0; k2 < nb; ++k2) {
                    int bits = this.table[tableIndex + j][1];
                    if (bits != 0 && bits != n) {
                        log.error((Object)String.format("incorrect codes", new Object[0]));
                        return -1;
                    }
                    this.table[tableIndex + j][1] = n;
                    this.table[tableIndex + j][0] = symbol;
                    j += inc;
                }
                continue;
            }
            int codePrefix = code >>> 32 - tableNbBits;
            int subtableBits = n -= tableNbBits;
            codes[codeOffset + i].bits = n;
            codes[codeOffset + i].code = code << tableNbBits;
            for (k = i + 1; k < nbCodes && (n = codes[codeOffset + k].bits - tableNbBits) > 0 && (code = codes[codeOffset + k].code) >>> 32 - tableNbBits == codePrefix; ++k) {
                codes[codeOffset + k].bits = n;
                codes[codeOffset + k].code = code << tableNbBits;
                subtableBits = Math.max(subtableBits, n);
            }
            subtableBits = Math.min(subtableBits, tableNbBits);
            int j = codePrefix;
            this.table[tableIndex + j][1] = -subtableBits;
            int index = this.buildTable(subtableBits, k - i, codes, codeOffset + i);
            if (index < 0) {
                return index;
            }
            this.table[tableIndex + j][0] = index;
            i = k - 1;
        }
        for (i = 0; i < tableSize; ++i) {
            if (this.table[tableIndex + i][1] != 0) continue;
            this.table[tableIndex + i][0] = -1;
        }
        return tableIndex;
    }

    private int allocTable(int size) {
        int index = this.tableSize;
        this.tableSize += size;
        this.tableAllocated = this.tableSize;
        int[][] newTable = new int[this.tableAllocated][2];
        if (this.table != null) {
            for (int i = 0; i < index; ++i) {
                newTable[i][0] = this.table[i][0];
                newTable[i][1] = this.table[i][1];
            }
        }
        this.table = newTable;
        return index;
    }

    public int getVLC2(IBitReader br, int maxDepth) {
        int index = br.peek(this.bits);
        int code = this.table[index][0];
        int n = this.table[index][1];
        if (maxDepth > 1 && n < 0) {
            br.skip(this.bits);
            int nbBits = -n;
            index = br.peek(nbBits) + code;
            code = this.table[index][0];
            n = this.table[index][1];
            if (maxDepth > 2 && n < 0) {
                br.skip(nbBits);
                nbBits = -n;
                index = br.peek(nbBits) + code;
                code = this.table[index][0];
                n = this.table[index][1];
            }
        }
        br.skip(n);
        return code;
    }

    public int getVLC2(IBitReader br) {
        return this.getVLC2(br, 1);
    }

    private static class VLCcode
    implements Comparable<VLCcode> {
        int bits;
        int symbol;
        int code;

        private VLCcode() {
        }

        @Override
        public int compareTo(VLCcode o) {
            return (this.code >>> 1) - (o.code >>> 1);
        }
    }
}

